function p = psd(sig, fftlength)
% power_spectral_density = psd(sig, fft_length)
%
% psd takes a signal and computes its power spectral density.
% This is done by first computing its fft, squaring its
% magnitude, changing to decibels, and adding a constant
% for power normalization so that a 1-bit signal at 4 kHz has
% SPL ~ 0 dB (in agreement with the auditory threshold), while
% a full-scale sinusoid has SPL ~ 90 dB.
powernormconst = 90.302;
p=powernormconst+10.*log10((abs(fft(sig,fftlength))).^2);
p=p(1:fftlength/2);